<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function type()
    {
        return $this->hasOne('App\Models\UserType', 'type');
    }

    public function country()
    {
        return $this->hasOne('App\Models\Country', 'country_id');
    }

    public function advertisements()
    {
        return $this->hasMany('App\Models\Advertisement', 'user_id');
    }

    public function messages()
    {
        return $this->hasMany('App\Models\Message');
    }

    public function favorites()
    {
        return $this->hasMany('App\Models\Favorite', 'id');
    }

}